<?php 
// Pastikan $data['title'] sudah diset di Controller
$title = $data['title'] ?? APP_NAME; 
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title; ?></title>
    
    <!-- Memuat Tailwind CSS CDN untuk styling yang cepat dan responsif -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Memuat Custom CSS Anda -->
    <link rel="stylesheet" href="<?= BASEURL; ?>public/css/style.css">

    <!-- Konfigurasi Tailwind Kustom (Opsional: untuk menggunakan warna kustom) -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary': '#3b82f6', // Biru
                        'accent': '#f59e0b',  // Kuning/Amber
                    }
                }
            }
        }
    </script>
    
    <!-- Memuat Font Awesome untuk ikon (opsional) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-gray-50 min-h-screen" data-baseurl="<?= BASEURL; ?>">

    <!-- Navbar/Header Utama -->
    <header class="bg-white shadow-md sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo Aplikasi -->
                <div class="flex-shrink-0">
                    <a href="<?= BASEURL; ?>" class="text-2xl font-bold text-primary"><?= APP_NAME; ?></a>
                </div>

                <!-- Menu Desktop -->
                <nav class="hidden md:flex space-x-4">
                    <a href="<?= BASEURL; ?>" class="text-gray-600 hover:text-primary px-3 py-2 rounded-md font-medium">Home</a>
                    <a href="<?= BASEURL; ?>tutorial" class="text-gray-600 hover:text-primary px-3 py-2 rounded-md font-medium">Tutorial</a>
                    <a href="<?= BASEURL; ?>contact" class="text-gray-600 hover:text-primary px-3 py-2 rounded-md font-medium">Kontak</a>
                    <!-- Tombol Login/Profil -->
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <a href="<?= BASEURL; ?>profile" class="bg-primary text-white hover:bg-blue-600 px-3 py-2 rounded-md font-medium">
                            <i class="fas fa-user mr-1"></i> Profil
                        </a>
                    <?php else: ?>
                        <a href="<?= BASEURL; ?>auth/login" class="bg-accent text-white hover:bg-amber-600 px-3 py-2 rounded-md font-medium">
                            <i class="fas fa-sign-in-alt mr-1"></i> Login
                        </a>
                    <?php endif; ?>
                </nav>

                <!-- Tombol Menu Mobile -->
                <div class="md:hidden">
                    <button id="menu-button" type="button" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-primary">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Menu Mobile (Tersembunyi) -->
        <div class="md:hidden hidden" id="mobile-menu">
            <div class="px-2 pt-2 pb-3 space-y-1 sm:px-3 border-t border-gray-100">
                <a href="<?= BASEURL; ?>" class="text-gray-700 hover:bg-gray-50 block px-3 py-2 rounded-md text-base font-medium">Home</a>
                <a href="<?= BASEURL; ?>tutorial" class="text-gray-700 hover:bg-gray-50 block px-3 py-2 rounded-md text-base font-medium">Tutorial</a>
                <a href="<?= BASEURL; ?>contact" class="text-gray-700 hover:bg-gray-50 block px-3 py-2 rounded-md text-base font-medium">Kontak</a>
                <?php if (isset($_SESSION['user_id'])): ?>
                    <a href="<?= BASEURL; ?>profile" class="text-white bg-primary block px-3 py-2 rounded-md text-base font-medium mt-2">Profil</a>
                <?php else: ?>
                    <a href="<?= BASEURL; ?>auth/login" class="text-white bg-accent block px-3 py-2 rounded-md text-base font-medium mt-2">Login</a>
                <?php endif; ?>
            </div>
        </div>
    </header>
    
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Area untuk menampilkan pesan flash (dari Helper.php) -->
        <?php showFlash(); ?>
        <!-- Konten halaman akan disisipkan di sini -->