<?php
// PATH KOREKSI: Dari views/home/ ke views/templates/
require_once '../templates/header.php'; 
?>

<div class="container mx-auto p-4 md:p-8">
    <h1 class="text-3xl font-bold text-center text-gray-800 mb-6">Konversi Pulsa ke Uang Tunai</h1>
    <p class="text-center text-gray-500 mb-8"><?= htmlspecialchars($data['pemberitahuan'] ?? 'Rate tinggi dan proses cepat.') ?></p>

    <!-- Pilihan Operator -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
        <?php foreach ($data['rates'] as $rate) : ?>
            <a href="<?= BASEURL ?>/konversipulsa/form/<?= htmlspecialchars($rate['slug']) ?>" 
               class="bg-white p-4 rounded-xl shadow-lg hover:shadow-xl transition duration-300 transform hover:-translate-y-1 flex flex-col items-center border-2 border-transparent hover:border-indigo-500"
               aria-label="Konversi Pulsa <?= htmlspecialchars($rate['operator_name']) ?>">
                <img src="<?= BASEURL ?>/public/images/<?= htmlspecialchars($rate['slug']) ?>.png" 
                     alt="Logo <?= htmlspecialchars($rate['operator_name']) ?>" 
                     class="w-16 h-16 object-contain mb-2">
                <p class="text-sm font-semibold text-gray-700"><?= htmlspecialchars($rate['operator_name']) ?></p>
                <span class="text-xs text-green-600 font-bold mt-1">Rate: <?= number_format($rate['rate'], 3) ?></span>
            </a>
        <?php endforeach; ?>
    </div>

    <!-- Informasi dan Tutorial Section -->
    <div class="mt-12 bg-gray-50 p-6 rounded-xl shadow-inner">
        <h2 class="text-2xl font-semibold text-gray-800 border-b pb-2 mb-4">Butuh Bantuan?</h2>
        <p class="text-gray-600 mb-4">Pelajari langkah-langkah mudah untuk melakukan konversi pulsa:</p>
        
        <a href="<?= BASEURL ?>/tutorial/index" class="inline-block px-6 py-3 bg-indigo-600 text-white font-semibold rounded-lg shadow-md hover:bg-indigo-700 transition duration-300">
            Lihat Semua Tutorial
        </a>
    </div>

</div>

<?php
// PATH KOREKSI: Dari views/home/ ke views/templates/
require_once '../templates/footer.php'; 
?>