/**
 * File: script.js
 * Deskripsi: Logika JavaScript klien untuk interaksi UI.
 */

document.addEventListener('DOMContentLoaded', function() {
    
    // Logika untuk menampilkan dan menyembunyikan menu mobile
    const menuButton = document.getElementById('menu-button');
    const mobileMenu = document.getElementById('mobile-menu');

    if (menuButton && mobileMenu) {
        menuButton.addEventListener('click', function() {
            mobileMenu.classList.toggle('hidden');
        });
    }

    // Logika untuk menangani klik operator pada halaman utama
    const operatorCards = document.querySelectorAll('.operator-card');
    
    operatorCards.forEach(card => {
        card.addEventListener('click', function() {
            // Ambil operator dari data-attribute (misalnya data-operator="tri")
            const operator = this.getAttribute('data-operator');
            
            // Logika sederhana: Arahkan pengguna ke form konversi
            if (operator) {
                // Gunakan BASEURL dari HTML/PHP yang disematkan, atau langsung ke path
                // Di lingkungan nyata, BASEURL harus disematkan di HTML dari PHP
                const baseUrl = document.body.getAttribute('data-baseurl') || '/';
                window.location.href = baseUrl + 'konversipulsa/form/' + operator;
            }
        });
    });

    // Logika untuk validasi form konversi
    const konversiForm = document.getElementById('konversi-form');
    if (konversiForm) {
        konversiForm.addEventListener('submit', function(e) {
            const nominal = document.getElementById('nominal').value;
            const norek = document.getElementById('norek').value;
            
            if (nominal < 10000 || norek.length < 5) {
                alert('Minimal nominal pulsa adalah Rp 10.000 dan pastikan nomor rekening valid.');
                // Mengganti alert() dengan modal custom jika diperlukan
                e.preventDefault(); // Mencegah submit form
            }
        });
    }

    // Fungsi utilitas untuk mengganti alert() (Sesuai instruksi)
    function showCustomMessage(message) {
        // Implementasi modal atau toast custom di sini
        console.log("Pesan Aplikasi: " + message);
        // Di sini Anda akan membuat dan menampilkan elemen div/modal
    }

    // Contoh: Mencegah error jika alert() tidak diizinkan
    if (typeof alert !== 'undefined') {
        // Ganti fungsi alert default (jika ini dijalankan di sandbox)
        // window.alert = showCustomMessage;
    }
});