<?php

// Class Controller adalah class dasar (parent) untuk semua Controller lain.
// Semua Controller seperti Home.php, Auth.php, dll., akan meng-extend class ini.
class Controller {

    /**
     * Metode untuk memuat Model dari folder app/models.
     * * @param string $model Nama class Model yang akan dimuat (contoh: 'KonversiModel').
     * @return object Instance dari class Model yang diminta.
     */
    public function model($model)
    {
        // Path ke file Model yang diminta
        $modelPath = '../app/models/' . $model . '.php';

        if (file_exists($modelPath)) {
            // Memuat file Model
            require_once $modelPath;
            
            // Membuat dan mengembalikan instance dari class Model
            return new $model();
        } else {
            // Jika file Model tidak ditemukan, hentikan eksekusi dengan pesan error
            die("Error: File Model tidak ditemukan di lokasi: " . $modelPath);
        }
    }

    /**
     * Metode untuk memuat View dari folder app/views.
     * * @param string $view Path view relatif dari folder views (contoh: 'home/index').
     * @param array $data Data yang akan dilewatkan ke view.
     * @return void
     */
    public function view($view, $data = [])
    {
        // Path ke file View yang diminta
        $viewPath = '../app/views/' . $view . '.php';

        if (file_exists($viewPath)) {
            // Mengekstrak array $data menjadi variabel individual
            // Contoh: $data['title'] akan menjadi variabel $title di dalam view
            extract($data);
            
            // Memuat file View
            require_once $viewPath;
        } else {
            // Jika file View tidak ditemukan
            die("Error: File View tidak ditemukan di lokasi: " . $viewPath);
        }
    }
}