<?php

// File ini berisi fungsi-fungsi pembantu yang dapat digunakan di seluruh aplikasi.

/**
 * Mengubah angka menjadi format mata uang Rupiah.
 * @param int|float $angka Angka nominal.
 * @return string Format Rupiah (Rp. 1.000).
 */
function formatRupiah($angka) {
    return 'Rp. ' . number_format($angka, 0, ',', '.');
}

/**
 * Mengubah string menjadi format slug (URL-friendly).
 * @param string $text Teks yang akan diubah.
 * @return string Slug.
 */
function slugify($text) {
    // Hilangkan karakter non-alfanumerik
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    // Transliterasi (untuk karakter non-Latin, jika diperlukan)
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    // Bersihkan karakter berlebihan
    $text = preg_replace('~[^-\w]+~', '', $text);
    // Hilangkan dash berlebihan di awal/akhir
    $text = trim($text, '-');
    $text = preg_replace('~-+~', '-', $text);
    // Ubah ke huruf kecil
    $text = strtolower($text);

    if (empty($text)) {
        return 'n-a';
    }
    return $text;
}

// ------------------------------------------
// Fungsi Flash Message (Pesan Pemberitahuan)
// ------------------------------------------

/**
 * Set pesan flash (disimpan di session) untuk ditampilkan sekali.
 * @param string $name Nama session untuk pesan.
 * @param string $message Isi pesan.
 * @param string $class Class CSS untuk styling (e.g., 'success', 'error', 'warning').
 */
function setFlash($name, $message, $class = 'success') {
    if (isset($_SESSION[$name])) {
        unset($_SESSION[$name]);
    }
    if (isset($_SESSION[$name . '_class'])) {
        unset($_SESSION[$name . '_class']);
    }
    
    $_SESSION[$name] = $message;
    $_SESSION[$name . '_class'] = $class;
}

/**
 * Menampilkan pesan flash jika ada di session.
 * @param string $name Nama session untuk pesan.
 * @return void
 */
function showFlash($name) {
    if (isset($_SESSION[$name])) {
        $class = $_SESSION[$name . '_class'];
        echo '<div class="alert alert-' . $class . '" role="alert">';
        echo $_SESSION[$name];
        echo '</div>';
        
        // Hapus session setelah ditampilkan
        unset($_SESSION[$name]);
        unset($_SESSION[$name . '_class']);
    }
}