<?php

// Class App bertindak sebagai Router utama aplikasi.
class App {
    
    // Properti default
    protected $controller = 'Home'; // Controller default (jika tidak ada yang ditentukan di URL)
    protected $method = 'index';    // Method default (jika tidak ada yang ditentukan di URL)
    protected $params = [];         // Parameter default

    public function __construct()
    {
        // 1. Parsing URL
        $url = $this->parseUrl();

        // 2. Cek Controller
        // Jika bagian pertama URL ada dan file Controller-nya ada
        if (!empty($url) && file_exists('../app/controllers/' . ucwords($url[0]) . '.php')) {
            // Ambil Controller dari URL
            $this->controller = ucwords($url[0]);
            // Hilangkan Controller dari array URL
            unset($url[0]);
        }
        
        // Memuat Controller
        require_once '../app/controllers/' . $this->controller . '.php';
        // Membuat instance Controller
        $this->controller = new $this->controller;

        // 3. Cek Method
        // Jika bagian kedua URL ada
        if (isset($url[1])) {
            // Cek apakah method tersebut ada di dalam Controller
            if (method_exists($this->controller, $url[1])) {
                $this->method = $url[1];
                // Hilangkan Method dari array URL
                unset($url[1]);
            }
        }

        // 4. Cek Parameter
        // Jika sisa array URL tidak kosong, itu adalah Parameter
        $this->params = $url ? array_values($url) : [];

        // 5. Jalankan Controller, Method, dan Parameter
        call_user_func_array([$this->controller, $this->method], $this->params);
    }

    // Metode untuk memecah dan membersihkan URL
    public function parseUrl()
    {
        // Contoh URL: http://localhost/project/konversipulsa/form/tri
        if (isset($_GET['url'])) {
            // Membersihkan URL dari karakter tidak perlu (slash di akhir)
            $url = rtrim($_GET['url'], '/');
            $url = filter_var($url, FILTER_SANITIZE_URL);
            // Memecah string URL menjadi array
            // Menghasilkan ['konversipulsa', 'form', 'tri']
            $url = explode('/', $url);
            return $url;
        }
        return [];
    }
}