<?php

class Auth extends Controller {

    // Method untuk menampilkan halaman login
    public function login()
    {
        $data['title'] = 'Login - ' . APP_NAME;
        // Tampilkan views/auth/login.php
        $this->view('auth/login', $data);
    }

    // Method untuk memproses data login (POST request)
    public function prosesLogin()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: ' . BASEURL . '/auth/login');
            exit;
        }

        $userModel = $this->model('UserModel');

        $username = filter_input(INPUT_POST, 'username', FILTER_SANITIZE_STRING);
        $password = filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING);

        // Cek kredensial di database
        $user = $userModel->checkUserCredentials($username, $password);

        if ($user) {
            // Login Berhasil: Set session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            
            // Arahkan ke halaman profile/home
            header('Location: ' . BASEURL . '/profile');
        } else {
            // Login Gagal: Set flash message error
            $data['error'] = 'Username atau Password salah.';
            $this->view('auth/login', $data);
        }
    }

    // Method untuk memproses logout
    public function logout()
    {
        // Hapus semua session
        session_start();
        session_unset();
        session_destroy();

        // Redirect ke halaman utama
        header('Location: ' . BASEURL);
        exit;
    }
}